<?php
// Test security config loading
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key, User-Agent');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    // Check if security_config.php exists and can be loaded
    if (!file_exists('security_config.php')) {
        echo json_encode(['success' => false, 'message' => 'security_config.php not found']);
        exit;
    }
    
    // Try to include it
    require_once 'security_config.php';
    
    // Check if constants are defined
    $status = [
        'success' => true,
        'message' => 'Security config loaded successfully',
        'api_key_defined' => defined('API_KEY'),
        'allowed_user_agents_defined' => defined('ALLOWED_USER_AGENTS'),
        'api_key_value' => defined('API_KEY') ? API_KEY : 'not_defined',
        'allowed_user_agents_value' => defined('ALLOWED_USER_AGENTS') ? ALLOWED_USER_AGENTS : 'not_defined'
    ];
    
    echo json_encode($status);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Exception: ' . $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
} catch (Error $e) {
    echo json_encode([
        'success' => false, 
        'message' => 'Error: ' . $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
}
?>