<?php
// Simple one-page test
// Upload and visit: https://ensi.online/simple_test.php

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Simple Hero Banners Test</h1>";
echo "<hr>";

// Load config
require_once 'admin/config.php';

// Start session
if (session_status() === PHP_SESSION_NONE) {
    session_name(ADMIN_SESSION_NAME);
    session_start();
}

// Test 1: Logged in?
echo "<h2>1. Login Status</h2>";
if (isset($_SESSION['admin_id'])) {
    echo "✅ Logged in as admin ID: " . $_SESSION['admin_id'] . "<br>";
} else {
    echo "❌ NOT logged in<br>";
    echo "<a href='admin/login.php'>→ Go login first</a><br>";
    exit;
}

// Test 2: Database
echo "<h2>2. Database</h2>";
$pdo = getDBConnection();
if ($pdo) {
    echo "✅ Database connected<br>";
} else {
    echo "❌ Database failed<br>";
    exit;
}

// Test 3: Table exists
echo "<h2>3. Table Check</h2>";
$check = $pdo->query("SHOW TABLES LIKE 'hero_banners'");
if ($check->rowCount() > 0) {
    $count = $pdo->query("SELECT COUNT(*) FROM hero_banners")->fetchColumn();
    echo "✅ hero_banners table exists with $count records<br>";
} else {
    echo "❌ hero_banners table NOT FOUND<br>";
    echo "→ Need to run SQL migration<br>";
    exit;
}

// Test 4: Try the exact query the API uses
echo "<h2>4. API Query Test</h2>";
try {
    // This is the exact query from admin/api/hero_banners.php
    $checkDismissalTable = $pdo->query("SHOW TABLES LIKE 'user_dismissed_banners'");
    $dismissalTableExists = $checkDismissalTable->rowCount() > 0;
    
    if ($dismissalTableExists) {
        $sql = "SELECT 
                  hb.*,
                  (SELECT COUNT(*) FROM user_dismissed_banners WHERE banner_id = hb.id) as dismissal_count
                FROM hero_banners hb
                ORDER BY hb.display_order ASC, hb.id DESC";
    } else {
        $sql = "SELECT 
                  hb.*,
                  0 as dismissal_count
                FROM hero_banners hb
                ORDER BY hb.display_order ASC, hb.id DESC";
    }
    
    $stmt = $pdo->query($sql);
    $banners = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "✅ Query successful! Found " . count($banners) . " banners<br>";
    echo "<pre>" . print_r($banners, true) . "</pre>";
    
} catch (Exception $e) {
    echo "❌ Query failed: " . $e->getMessage() . "<br>";
    exit;
}

// Test 5: What does the API actually return?
echo "<h2>5. Testing Actual API Endpoint</h2>";
echo "<p><a href='admin/api/hero_banners.php?action=list' target='_blank'>→ Open API in new tab</a></p>";
echo "<p>You should see JSON with banners. If not, tell me what you see!</p>";

// Test 6: What about the page?
echo "<h2>6. Open The Actual Page</h2>";
echo "<p><a href='admin/hero_banners.php' target='_blank'>→ Open hero_banners.php in new tab</a></p>";
echo "<p><strong>What happens when you click?</strong></p>";
echo "<ul>";
echo "<li>Blank page?</li>";
echo "<li>Error message?</li>";
echo "<li>Page loads but shows 'Failed to load banners'?</li>";
echo "<li>Page loads perfectly?</li>";
echo "</ul>";
echo "<p><strong>Tell me EXACTLY what you see!</strong></p>";

?>
