<?php
// Standalone test to get products
header('Content-Type: application/json');

// Database credentials
define('DB_HOST', 'localhost');
define('DB_USER', 'playbdqv_finalensi');
define('DB_PASS', 'playbdqv_finalensi');
define('DB_NAME', 'playbdqv_finalensi');

try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        echo json_encode([
            'success' => false,
            'error' => 'Connection failed: ' . $conn->connect_error
        ]);
        exit;
    }
    
    $platform = $_GET['platform'] ?? 'ios';
    
    $stmt = $conn->prepare("
        SELECT product_id, title, price_usd, duration_days, description, features
        FROM subscription_products
        WHERE is_active = 1 AND (platform = ? OR platform = 'both')
        ORDER BY price_usd ASC
    ");
    
    $stmt->bind_param("s", $platform);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $products = [];
    while ($row = $result->fetch_assoc()) {
        $products[] = [
            'product_id' => $row['product_id'],
            'title' => $row['title'],
            'price_usd' => $row['price_usd'],
            'duration_days' => $row['duration_days'],
            'description' => $row['description'],
            'features' => json_decode($row['features'] ?? '[]')
        ];
    }
    
    echo json_encode([
        'success' => true,
        'count' => count($products),
        'products' => $products
    ], JSON_PRETTY_PRINT);
    
    $stmt->close();
    $conn->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_PRETTY_PRINT);
}
