<?php
// Simple debug version to identify the issue
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key, User-Agent');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {
    // Check if security_config.php exists
    if (!file_exists('security_config.php')) {
        echo json_encode(['success' => false, 'message' => 'security_config.php not found']);
        exit;
    }
    
    // Try to include security config
    require_once 'security_config.php';
    
    // Check if constants are defined
    if (!defined('API_KEY')) {
        echo json_encode(['success' => false, 'message' => 'API_KEY not defined']);
        exit;
    }
    
    if (!defined('ALLOWED_USER_AGENTS')) {
        echo json_encode(['success' => false, 'message' => 'ALLOWED_USER_AGENTS not defined']);
        exit;
    }
    
    // Check headers
    $apiKey = $_SERVER['HTTP_X_API_KEY'] ?? 'not_set';
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'not_set';
    
    echo json_encode([
        'success' => true,
        'message' => 'Debug info',
        'api_key_received' => $apiKey,
        'user_agent_received' => $userAgent,
        'expected_api_key' => API_KEY,
        'allowed_user_agents' => ALLOWED_USER_AGENTS,
        'post_data' => $_POST
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Exception: ' . $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
} catch (Error $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}
?>