<?php
/**
 * Test if subscription tables exist in database
 */
require_once 'config.php';

$pdo = getDBConnection();

if (!$pdo) {
    die("❌ Database connection failed!");
}

echo "<h2>Testing Subscription Tables</h2>";
echo "<hr>";

// List of required tables
$tables = [
    'subscription_packages',
    'user_subscriptions',
    'payment_requests',
    'subscription_logs',
    'email_queue',
    'payment_settings'
];

echo "<h3>Checking Tables:</h3>";
foreach ($tables as $table) {
    try {
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM `$table`");
        $result = $stmt->fetch();
        echo "✅ <strong>$table</strong> exists - {$result['count']} records<br>";
    } catch (PDOException $e) {
        echo "❌ <strong>$table</strong> NOT FOUND - Error: " . $e->getMessage() . "<br>";
    }
}

echo "<hr>";
echo "<h3>Testing Functions:</h3>";

// Test requireAdminAuth
echo "Testing requireAdminAuth(): ";
try {
    session_start();
    if (isset($_SESSION['admin_id'])) {
        echo "✅ Admin authenticated (ID: {$_SESSION['admin_id']})<br>";
    } else {
        echo "⚠️ Not logged in (this is normal if testing directly)<br>";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

// Test getCurrentAdmin
echo "Testing getCurrentAdmin(): ";
try {
    if (isset($_SESSION['admin_id'])) {
        $admin = getCurrentAdmin();
        if ($admin) {
            echo "✅ Admin data retrieved: " . $admin['username'] . "<br>";
        } else {
            echo "❌ Failed to get admin data<br>";
        }
    } else {
        echo "⚠️ Skipped (not logged in)<br>";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<hr>";
echo "<h3>Database Configuration:</h3>";
echo "Host: " . DB_HOST . "<br>";
echo "Database: " . DB_NAME . "<br>";
echo "User: " . DB_USER . "<br>";

echo "<hr>";
echo "<p><strong>Access this file at:</strong> https://ensi.online/admin/test_subscription_tables.php</p>";
?>
