<?php
require_once 'config.php';
$adminId = requireAdminAuth();
$admin = getCurrentAdmin();

$pdo = getDBConnection();

// Pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$perPage = 50;
$offset = ($page - 1) * $perPage;

// Get total logs
$totalStmt = $pdo->query("SELECT COUNT(*) as total FROM admin_logs");
$totalLogs = $totalStmt->fetch()['total'];
$totalPages = ceil($totalLogs / $perPage);

// Get logs
$stmt = $pdo->prepare("
    SELECT al.*, a.username, a.full_name 
    FROM admin_logs al
    JOIN admins a ON al.admin_id = a.id
    ORDER BY al.created_at DESC
    LIMIT ? OFFSET ?
");
$stmt->execute([$perPage, $offset]);
$logs = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Activity Logs - Admin Panel</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>Activity Logs</h1>
            <p>Track all admin activities</p>
        </div>
        
        <div class="content-card">
            <div class="card-header">
                <h2>Recent Activities</h2>
                <span><?php echo number_format($totalLogs); ?> total logs</span>
            </div>
            
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Admin</th>
                            <th>Action</th>
                            <th>Description</th>
                            <th>IP Address</th>
                            <th>Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($logs)): ?>
                            <tr>
                                <td colspan="6" style="text-align: center; padding: 30px; color: #999;">
                                    No activity logs found
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($logs as $log): ?>
                                <tr>
                                    <td><?php echo $log['id']; ?></td>
                                    <td><?php echo htmlspecialchars($log['full_name'] ?? $log['username']); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo getActionBadge($log['action']); ?>">
                                            <?php echo htmlspecialchars($log['action']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($log['description'] ?? '-'); ?></td>
                                    <td><?php echo htmlspecialchars($log['ip_address'] ?? '-'); ?></td>
                                    <td><?php echo date('M d, Y H:i:s', strtotime($log['created_at'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if ($totalPages > 1): ?>
                <div style="margin-top: 20px; text-align: center;">
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <a href="?page=<?php echo $i; ?>" 
                           class="btn <?php echo $i === $page ? 'btn-primary' : 'btn-outline'; ?>"
                           style="margin: 0 5px; padding: 8px 16px;">
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

<?php
function getActionBadge($action) {
    $badges = [
        'login' => 'success',
        'logout' => 'info',
        'create_user' => 'success',
        'update_user' => 'warning',
        'delete_user' => 'danger',
        'failed_login' => 'danger',
    ];
    return $badges[$action] ?? 'info';
}
?>
