<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Ensi.lk</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 50px 40px;
            width: 100%;
            max-width: 420px;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo h1 {
            color: #667eea;
            font-size: 32px;
            margin-bottom: 5px;
        }
        
        .logo p {
            color: #666;
            font-size: 14px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            color: #333;
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 14px 16px;
            border: 2px solid #e1e8ed;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn-login {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .btn-login:active {
            transform: translateY(0);
        }
        
        .alert {
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        
        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }
        
        .alert-info {
            background: #e3f2fd;
            color: #1976d2;
            border: 1px solid #bbdefb;
        }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #999;
            font-size: 13px;
        }
        
        .security-note {
            background: #fff3cd;
            border: 1px solid #ffeeba;
            color: #856404;
            padding: 12px;
            border-radius: 8px;
            font-size: 12px;
            margin-top: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h1>🔐 Admin Panel</h1>
            <p>Ensi.lk Management System</p>
        </div>
        
        <?php
        session_name('ensi_admin_session');
        session_start();
        
        // Redirect if already logged in
        if (isset($_SESSION['admin_id'])) {
            header('Location: dashboard.php');
            exit;
        }
        
        $error = '';
        $info = '';
        
        if (isset($_GET['timeout'])) {
            $info = 'Session expired. Please login again.';
        }
        
        if (isset($_GET['logout'])) {
            $info = 'Logged out successfully.';
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            require_once 'config.php';
            
            $username = sanitizeInput($_POST['username'] ?? '');
            $password = $_POST['password'] ?? '';
            
            if (empty($username) || empty($password)) {
                $error = 'Please enter both username and password.';
            } else {
                $pdo = getDBConnection();
                if ($pdo) {
                    try {
                        $stmt = $pdo->prepare("SELECT id, username, password_hash, full_name, role FROM admins WHERE username = ? AND is_active = 1");
                        $stmt->execute([$username]);
                        $admin = $stmt->fetch();
                        
                        if ($admin && password_verify($password, $admin['password_hash'])) {
                            // Login successful
                            $_SESSION['admin_id'] = $admin['id'];
                            $_SESSION['admin_username'] = $admin['username'];
                            $_SESSION['admin_role'] = $admin['role'];
                            $_SESSION['admin_name'] = $admin['full_name'];
                            $_SESSION['last_activity'] = time();
                            
                            // Update last login
                            $updateStmt = $pdo->prepare("UPDATE admins SET last_login = NOW() WHERE id = ?");
                            $updateStmt->execute([$admin['id']]);
                            
                            // Log activity
                            logAdminActivity($admin['id'], 'login', 'Admin logged in');
                            
                            header('Location: dashboard.php');
                            exit;
                        } else {
                            $error = 'Invalid username or password.';
                            
                            // Log failed attempt
                            if ($admin) {
                                logAdminActivity($admin['id'], 'failed_login', 'Failed login attempt');
                            }
                        }
                    } catch (Exception $e) {
                        $error = 'Login failed. Please try again.';
                        error_log("Admin login error: " . $e->getMessage());
                    }
                } else {
                    $error = 'Database connection failed.';
                }
            }
        }
        ?>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <?php if ($info): ?>
            <div class="alert alert-info"><?php echo htmlspecialchars($info); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required autofocus autocomplete="username" value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
            </div>
            
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required autocomplete="current-password">
            </div>
            
            <button type="submit" class="btn-login">Login to Admin Panel</button>
        </form>
        
        <div class="security-note">
            🔒 This is a restricted area. All activities are logged.
        </div>
        
        <div class="footer">
            © 2024 Ensi.lk - Admin Panel v1.0
        </div>
    </div>
</body>
</html>
