<?php
/**
 * Test script to check comments database status
 */

require_once 'config.php';

header('Content-Type: application/json; charset=UTF-8');

try {
    $conn = getDBConnection();
    
    if ($conn === null) {
        throw new PDOException("Database connection failed");
    }
    
    // Check if lesson_comments table exists
    $tableCheck = $conn->query("SHOW TABLES LIKE 'lesson_comments'");
    $tableExists = $tableCheck->rowCount() > 0;
    
    $result = [
        'success' => true,
        'database_connected' => true,
        'table_exists' => $tableExists,
        'database_name' => DB_NAME
    ];
    
    if ($tableExists) {
        // Get table structure
        $structure = $conn->query("DESCRIBE lesson_comments")->fetchAll(PDO::FETCH_ASSOC);
        $result['table_structure'] = $structure;
        
        // Count rows
        $count = $conn->query("SELECT COUNT(*) as total FROM lesson_comments")->fetch(PDO::FETCH_ASSOC);
        $result['total_comments'] = $count['total'];
        
        // Count approved
        $approved = $conn->query("SELECT COUNT(*) as total FROM lesson_comments WHERE is_approved = 1")->fetch(PDO::FETCH_ASSOC);
        $result['approved_comments'] = $approved['total'];
    }
    
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'error_code' => $e->getCode()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
?>
