<?php
/**
 * Create lesson_comments table
 * Run this once to set up the comments system
 */

require_once 'config.php';

try {
    $conn = getDBConnection();
    
    // Create lesson_comments table
    $sql = "CREATE TABLE IF NOT EXISTS `lesson_comments` (
        `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        `lesson_id` INT(11) UNSIGNED NOT NULL,
        `user_id` INT(11) UNSIGNED NOT NULL,
        `comment` TEXT NOT NULL,
        `is_approved` TINYINT(1) DEFAULT 0 COMMENT 'Admin approval required',
        `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        
        PRIMARY KEY (`id`),
        KEY `idx_lesson_id` (`lesson_id`),
        KEY `idx_user_id` (`user_id`),
        KEY `idx_approved` (`is_approved`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    
    $conn->exec($sql);
    
    echo json_encode([
        'success' => true,
        'message' => 'Comments table created successfully!'
    ], JSON_UNESCAPED_UNICODE);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error creating table: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>
