<?php
// Enable error display
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Quick Test</h1>";

// Test 1: Basic PHP
echo "<h2>Test 1: PHP is working</h2>";
echo "✅ PHP is executing<br>";

// Test 2: Config file
echo "<h2>Test 2: Loading config.php</h2>";
try {
    require_once 'config.php';
    echo "✅ config.php loaded<br>";
    echo "DB_NAME: " . DB_NAME . "<br>";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    die();
}

// Test 3: Database connection
echo "<h2>Test 3: Database Connection</h2>";
try {
    $pdo = getDBConnection();
    if ($pdo) {
        echo "✅ Database connected<br>";
    } else {
        echo "❌ Database connection returned null<br>";
        die();
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    die();
}

// Test 4: Check tables
echo "<h2>Test 4: Check Tables</h2>";
try {
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "✅ Found " . count($tables) . " tables:<br>";
    echo implode(', ', $tables) . "<br>";
    
    // Check if app_settings exists
    if (in_array('app_settings', $tables)) {
        echo "✅ app_settings table exists<br>";
    } else {
        echo "❌ app_settings table NOT found<br>";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

// Test 5: Query app_settings
echo "<h2>Test 5: Query app_settings</h2>";
try {
    $stmt = $pdo->query("SELECT * FROM app_settings ORDER BY setting_key");
    $settings = $stmt->fetchAll();
    echo "✅ Found " . count($settings) . " settings:<br>";
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Key</th><th>Value</th></tr>";
    foreach ($settings as $setting) {
        echo "<tr><td>{$setting['setting_key']}</td><td>{$setting['setting_value']}</td></tr>";
    }
    echo "</table>";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

// Test 6: Check includes directory
echo "<h2>Test 6: Check includes/ directory</h2>";
if (is_dir(__DIR__ . '/includes')) {
    echo "✅ includes/ directory exists<br>";
    $files = scandir(__DIR__ . '/includes');
    $phpFiles = array_filter($files, function($f) { return pathinfo($f, PATHINFO_EXTENSION) === 'php'; });
    echo "PHP files: " . implode(', ', $phpFiles) . "<br>";
} else {
    echo "❌ includes/ directory NOT found<br>";
}

echo "<hr>";
echo "<h2>All Tests Complete!</h2>";
echo "<p><a href='app_settings.php'>Try app_settings.php now</a></p>";
?>
